--
-- OVAL-id: OVAL14
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0158' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File Xsun exists

	(SELECT 'File Xsun exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/Xsun')

AND NOT EXISTS

	-- Patch 108652-52 or later installed

	(SELECT 'Patch 108652-52 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '52')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File Xsun SGID and executable
	(SELECT 'File Xsun SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			SGID = '1')

	AND EXISTS
		-- File Xsun SGID and executable

		(SELECT 'File Xsun SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/Xsun' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

