--
-- OVAL-id: OVAL135
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0255' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gnupg version is less than 1.2.1-4

	(SELECT 'gnupg version is less than 1.2.1-4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gnupg' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.2.1' AND
		RPMTestedRelease = '4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gnupg is executable
	(SELECT '/usr/bin/gnupg is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gnupg is executable

		(SELECT '/usr/bin/gnupg is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gnupg' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gnupg is executable

		(SELECT '/usr/bin/gnupg is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gnupg' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

