--
-- OVAL-id: OVAL134
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0010' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- jscript.dll version is 5.1, 5.5, or 5.6 
	(SELECT 'jscript.dll version is 5.1, 5.5, or 5.6 ' FROM Placeholder WHERE

	EXISTS
		-- the version of jscript.dll is less than 5.1.0.8513

		(SELECT 'the version of jscript.dll is less than 5.1.0.8513' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\jscript.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 1 OR (Version2 = 1 AND
			(Version3 < 0 OR Version3 = 0 AND
			Version4 < 8513))))))

	AND EXISTS
		-- the version of jscript.dll is less than 5.5.0.8513

		(SELECT 'the version of jscript.dll is less than 5.5.0.8513' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\jscript.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 5 OR (Version2 = 5 AND
			(Version3 < 0 OR Version3 = 0 AND
			Version4 < 8513))))))

	AND EXISTS
		-- the version of jscript.dll is less than 5.6.0.8513

		(SELECT 'the version of jscript.dll is less than 5.6.0.8513' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\jscript.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 6 OR (Version2 = 6 AND
			(Version3 < 0 OR Version3 = 0 AND
			Version4 < 8513)))))))

AND EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- The patch js56nen.exe is installed for version 5.1, 5.5, or 5.6
	(SELECT 'The patch js56nen.exe is installed for version 5.1, 5.5, or 5.6' FROM Placeholder WHERE

	EXISTS
		-- the patch js56nen.exe (5.6.0.8513 version) is installed

		(SELECT 'the patch js56nen.exe (5.6.0.8513 version) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{4f645220-306d-11d2-995d-00c04f98bbc9}' AND
			EntryName = 'Version' AND
			EntryValue = '5,6,0,8513')

	AND EXISTS
		-- the patch js56nen.exe (5.1.0.8513 version) is installed

		(SELECT 'the patch js56nen.exe (5.1.0.8513 version) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{4f645220-306d-11d2-995d-00c04f98bbc9}' AND
			EntryName = 'Version' AND
			EntryValue = '5,1,0,8513')

	AND EXISTS
		-- the patch js56nen.exe (5.5.0.8513 version) is installed

		(SELECT 'the patch js56nen.exe (5.5.0.8513 version) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{4f645220-306d-11d2-995d-00c04f98bbc9}' AND
			EntryName = 'Version' AND
			EntryValue = '5,5,0,8513'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

