--
-- OVAL-id: OVAL133
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0354' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- ghostscript version is less than 7.05-32.1

	(SELECT 'ghostscript version is less than 7.05-32.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'ghostscript' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '7.05' AND
		RPMTestedRelease = '32.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gs is executable
	(SELECT '/usr/bin/gs is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gs is executable

		(SELECT '/usr/bin/gs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gs' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gs is executable

		(SELECT '/usr/bin/gs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gs' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/gs is executable

		(SELECT '/usr/bin/gs is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gs' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

