--
-- OVAL-id: OVAL131
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0652' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File xlock exists

	(SELECT 'File xlock exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/xlock')

AND NOT EXISTS

	-- Patch 108376-30 or later installed

	(SELECT 'Patch 108376-30 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108376' AND
		PatchVersion >= '30')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File xlock SUID and executable
	(SELECT 'File xlock SUID and executable' FROM Placeholder WHERE

	EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			SUID = '1')

	AND EXISTS
		-- File xlock SUID and executable

		(SELECT 'File xlock SUID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/xlock' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

