--
-- OVAL-id: OVAL1273
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0722' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND EXISTS

	-- System and Network Administration Framework Installed

	(SELECT 'System and Network Administration Framework Installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWadmfw')

AND NOT EXISTS

	-- Patch 116457-02 or later installed

	(SELECT 'Patch 116457-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116457' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 116442-01 or later installed

	(SELECT 'Patch 116442-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116442' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 116454-01 or later installed

	(SELECT 'Patch 116454-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '116454' AND
		PatchVersion >= '01')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- inetd.conf contains sadmind

	(SELECT 'inetd.conf contains sadmind' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/sbin/sadmind')

AND NOT EXISTS

	-- Sadmin called using strong authentication

	(SELECT 'Sadmin called using strong authentication' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/sbin/sadmind' AND
		ServerArguments = '-S 2')

--
-- ### END VULNERABLE CONFIGURATION
;

