--
-- OVAL-id: OVAL1079
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2000-1079' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 95, 98, NT or 2000 is installed
	(SELECT 'Windows 95, 98, NT or 2000 is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 95 or 98 Installed

		(SELECT 'Windows 95 or 98 Installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
			EntryName = 'Version' AND
			EntryValue LIKE 'Windows%')

	OR EXISTS
		-- Windows NT or 2000 Installed
		(SELECT 'Windows NT or 2000 Installed' FROM Placeholder WHERE

		EXISTS
			-- Windows NT 4.0 is installed

			(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CurrentVersion' AND
				EntryValue = '4.0')

		OR EXISTS
			-- Windows 2000 is installed

			(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CurrentVersion' AND
				EntryValue = '5.0')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- TCP/IP NetBIOS not disabled

	(SELECT 'TCP/IP NetBIOS not disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\LmHosts' AND
		EntryName = 'Start' AND
		EntryValue != '4')

AND EXISTS

	-- WINS Client binding not disabled

	(SELECT 'WINS Client binding not disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NetBT\Parameters\Interfaces\Tcpip%' AND
		EntryName = 'NetbiosOptions' AND
		EntryValue != '2')

--
-- ### END VULNERABLE CONFIGURATION
;

