--
-- OVAL-id: OVAL1065
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0179' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- openoffice version is less than 1.1.0-15.EL

	(SELECT 'openoffice version is less than 1.1.0-15.EL' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'openoffice' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.0' AND
		RPMTestedRelease = '15.EL' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- OpenOffice Permissions
	(SELECT 'OpenOffice Permissions' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/oocalc is executable
		(SELECT '/usr/bin/oocalc is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oocalc is executable

			(SELECT '/usr/bin/oocalc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oocalc' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oocalc is executable

			(SELECT '/usr/bin/oocalc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oocalc' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oocalc is executable

			(SELECT '/usr/bin/oocalc is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oocalc' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/oodraw is executable
		(SELECT '/usr/bin/oodraw is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oodraw is executable

			(SELECT '/usr/bin/oodraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oodraw' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oodraw is executable

			(SELECT '/usr/bin/oodraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oodraw' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oodraw is executable

			(SELECT '/usr/bin/oodraw is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oodraw' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/oofice is executable
		(SELECT '/usr/bin/oofice is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oofice is executable

			(SELECT '/usr/bin/oofice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oofice' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oofice is executable

			(SELECT '/usr/bin/oofice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oofice' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oofice is executable

			(SELECT '/usr/bin/oofice is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oofice' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ooimpress is executable
		(SELECT '/usr/bin/ooimpress is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ooimpress is executable

			(SELECT '/usr/bin/ooimpress is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ooimpress' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ooimpress is executable

			(SELECT '/usr/bin/ooimpress is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ooimpress' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ooimpress is executable

			(SELECT '/usr/bin/ooimpress is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ooimpress' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/oowriter is executable
		(SELECT '/usr/bin/oowriter is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/oowriter is executable

			(SELECT '/usr/bin/oowriter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oowriter' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/oowriter is executable

			(SELECT '/usr/bin/oowriter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oowriter' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/oowriter is executable

			(SELECT '/usr/bin/oowriter is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/oowriter' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

