--
-- OVAL-id: OVAL1030
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0807' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 (excluding WinXP 64-bit, Version 2003) is installed
	(SELECT 'Windows Server 2003 (excluding WinXP 64-bit, Version 2003) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows Server 2003 is installed

		(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.2')

	AND NOT EXISTS
		-- this is an NT Workstation

		(SELECT 'this is an NT Workstation' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductType' AND
			EntryValue = 'WinNT'))

AND EXISTS

	-- a vulnerable version of rpcproxy.dll exists on Server 2003
	(SELECT 'a vulnerable version of rpcproxy.dll exists on Server 2003' FROM Placeholder WHERE

	EXISTS
		-- machine has followed the GDR update path and rpcproxy.dll is less than 5.2.3790.137

		(SELECT 'machine has followed the GDR update path and rpcproxy.dll is less than 5.2.3790.137' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\rpcproxy.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			development_class != 'srv03_qfe' AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 137))))))

	OR EXISTS
		-- machine has followed the QFE update path and rpcproxy.dll is less than 5.2.3790.141

		(SELECT 'machine has followed the QFE update path and rpcproxy.dll is less than 5.2.3790.141' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\system32\rpcproxy.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'SystemRoot') AND
			development_class = 'srv03_qfe' AND
			(Version1 < 5 OR (Version1 = 5 AND
			(Version2 < 2 OR (Version2 = 2 AND
			(Version3 < 3790 OR Version3 = 3790 AND
			Version4 < 141)))))))

AND NOT EXISTS

	-- the patch kb828741 is installed

	(SELECT 'the patch kb828741 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB828741' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- COM Internet Services are enabled

	(SELECT 'COM Internet Services are enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ole' AND
		EntryName = 'EnableDCOMHTTP' AND
		EntryValue = 'Y')

--
-- ### END VULNERABLE CONFIGURATION
;

