--
-- OVAL-id: OVAL1027
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0202' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- Vulnerable versions of DirectX
	(SELECT 'Vulnerable versions of DirectX' FROM Placeholder WHERE

	EXISTS
		-- Unpatched DirectX 7.0
		(SELECT 'Unpatched DirectX 7.0' FROM Placeholder WHERE

		EXISTS
			-- DirectX 7.0x Installed

			(SELECT 'DirectX 7.0x Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.07%')

		AND EXISTS
			-- File %windir%\system32\dplayx.dll version is less than 5.0.2195.6927

			(SELECT 'File %windir%\system32\dplayx.dll version is less than 5.0.2195.6927' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 2195 OR Version3 = 2195 AND
				Version4 < 6927))))))

		AND NOT EXISTS
			-- Patch Windows2000-KB839643-x86-ENU.EXE Installed

			(SELECT 'Patch Windows2000-KB839643-x86-ENU.EXE Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643' AND
				EntryName = 'Installed' AND
				EntryValue = '1'))

	OR EXISTS
		-- Unpatched DirectX 8.0x
		(SELECT 'Unpatched DirectX 8.0x' FROM Placeholder WHERE

		EXISTS
			-- DirectX 8.0x Installed

			(SELECT 'DirectX 8.0x Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.08.00%')

		AND EXISTS
			-- File %windir%\system32\dplayx.dll version is less than 5.0.2258.410

			(SELECT 'File %windir%\system32\dplayx.dll version is less than 5.0.2258.410' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 2258 OR Version3 = 2258 AND
				Version4 < 410))))))

		AND NOT EXISTS
			-- Patch DirectX80-KB839643-x86-ENU Installed

			(SELECT 'Patch DirectX80-KB839643-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX8' AND
				EntryName = 'Installed' AND
				EntryValue = '1'))

	OR EXISTS
		-- Unpatched DirectX 8.1x
		(SELECT 'Unpatched DirectX 8.1x' FROM Placeholder WHERE

		EXISTS
			-- DirectX 8.1x Installed

			(SELECT 'DirectX 8.1x Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.08.01%')

		AND EXISTS
			-- File %windir%\system32\dplayx.dll version is less than 5.1.2600.891

			(SELECT 'File %windir%\system32\dplayx.dll version is less than 5.1.2600.891' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 891))))))

		AND NOT EXISTS
			-- Patch DirectX81-KB839643-x86-ENU Installed

			(SELECT 'Patch DirectX81-KB839643-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX81' AND
				EntryName = 'Installed' AND
				EntryValue = '1'))

	OR EXISTS
		-- Unpatched DirectX 8.2x
		(SELECT 'Unpatched DirectX 8.2x' FROM Placeholder WHERE

		EXISTS
			-- DirectX 8.2x Installed

			(SELECT 'DirectX 8.2x Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.08.02%')

		AND EXISTS
			-- File %windir%\system32\dplayx.dll version is less than 5.2.3677.144

			(SELECT 'File %windir%\system32\dplayx.dll version is less than 5.2.3677.144' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 2 OR (Version2 = 2 AND
				(Version3 < 3677 OR Version3 = 3677 AND
				Version4 < 144))))))

		AND NOT EXISTS
			-- Patch DirectX82-KB839643-x86-ENU Installed

			(SELECT 'Patch DirectX82-KB839643-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX82' AND
				EntryName = 'Installed' AND
				EntryValue = '1'))

	OR EXISTS
		-- Unpatched DirectX 9.0x
		(SELECT 'Unpatched DirectX 9.0x' FROM Placeholder WHERE

		EXISTS
			-- DirectX 9.0x Installed

			(SELECT 'DirectX 9.0x Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\DirectX' AND
				EntryName = 'Version' AND
				EntryValue LIKE '4.09.00%')

		AND EXISTS
			-- File %windir%\system32\dplayx.dll version is less than 5.3.0.903

			(SELECT 'File %windir%\system32\dplayx.dll version is less than 5.3.0.903' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\dplayx.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 3 OR (Version2 = 3 AND
				(Version3 < 0 OR Version3 = 0 AND
				Version4 < 903))))))

		AND NOT EXISTS
			-- Patch DirectX90-KB839643-x86-ENU Installed

			(SELECT 'Patch DirectX90-KB839643-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB839643-DirectX9' AND
				EntryName = 'Installed' AND
				EntryValue = '1')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

