--
-- OVAL-id: OVAL1022
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0049' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Microsoft Exchange 2000 Installed

	(SELECT 'Microsoft Exchange 2000 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Uninstall\%' AND
		EntryName = 'DisplayName' AND
		EntryValue = 'Microsoft Exchange 2000')

AND EXISTS

	-- File %ExchangeInstallDir%\bin\mad.exe is less than 6.0.5770.21

	(SELECT 'File %ExchangeInstallDir%\bin\mad.exe is less than 6.0.5770.21' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\bin\mad.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup' AND
			EntryName = 'Services') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 5700 OR Version3 = 5700 AND
		Version4 < 21))))))

AND NOT EXISTS

	-- Patch Q316056 installed

	(SELECT 'Patch Q316056 installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Updates\Exchange Server 2000\SP3\Q316056')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Everyone group given remote access permissions

	(SELECT 'Everyone group given remote access permissions' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\SecurePipeServers\winreg' AND
		EntryName = 'Everyone')

--
-- ### END VULNERABLE CONFIGURATION
;

