--
-- OVAL-id: OVAL1016
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0663' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 (domain controller) is installed
	(SELECT 'Windows 2000 (domain controller) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- this is an NT Server (domain controller)

		(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
			EntryName = 'ProductType' AND
			EntryValue LIKE '%LanmanNT%'))

AND EXISTS

	-- the version of lsasrv.dll is less than 5.0.2195.6902

	(SELECT 'the version of lsasrv.dll is less than 5.0.2195.6902' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\lsasrv.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6902))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

