--
-- OVAL-id: OVAL1006
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0519' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed

	(SELECT 'squirrelmail rpm version prior to 1.4.3-0.e3.1 is installed' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'squirrelmail' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.4.3' AND
		RPMTestedRelease = '0.e3.1' AND
		RPMInstalledVersion = 'earlier')

AND EXISTS

	-- php rpm is installed

	(SELECT 'php rpm is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'php')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening on the network

	(SELECT 'httpd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

AND EXISTS

	-- /etc/httpd/modules/libphp4.so exists

	(SELECT '/etc/httpd/modules/libphp4.so exists' FROM RedHat_FileAttributes WHERE
		FilePath = '/etc/httpd/modules/libphp4.so')

--
-- ### END VULNERABLE CONFIGURATION
;

