--
-- OVAL-id: OVAL905
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0367' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- ethereal version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- ethereal-gnome version is less than 0.10.3-0.30E.1

		(SELECT 'ethereal-gnome version is less than 0.10.3-0.30E.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'ethereal-gnome' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '0.10.3' AND
			RPMTestedRelease = '0.30E.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/ethereal is executable
		(SELECT '/usr/bin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ethereal is executable

			(SELECT '/usr/bin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/sbin/ethereal is executable
		(SELECT '/usr/sbin/ethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/sbin/ethereal is executable

			(SELECT '/usr/sbin/ethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/sbin/ethereal' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/tethereal is executable
		(SELECT '/usr/bin/tethereal is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/tethereal is executable

			(SELECT '/usr/bin/tethereal is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/tethereal' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

