--
-- OVAL-id: OVAL86
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0090' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 Installed

	(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.8')

AND EXISTS

	-- File lbxproxy exists

	(SELECT 'File lbxproxy exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/openwin/bin/lbxproxy')

AND NOT EXISTS

	-- Patch 108652-51 or later installed

	(SELECT 'Patch 108652-51 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108652' AND
		PatchVersion >= '51')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- File lbxproxy SGID and executable
	(SELECT 'File lbxproxy SGID and executable' FROM Placeholder WHERE

	EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			SGID = '1')

	AND EXISTS
		-- File lbxproxy SGID and executable

		(SELECT 'File lbxproxy SGID and executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/openwin/bin/lbxproxy' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

