--
-- OVAL-id: OVAL833
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0110' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- libxml2 version is less than 2.5.10-6

		(SELECT 'libxml2 version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libxml2-devel version is less than 2.5.10-6

		(SELECT 'libxml2-devel version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2-devel' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- libxml2-python version is less than 2.5.10-6

		(SELECT 'libxml2-python version is less than 2.5.10-6' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'libxml2-python' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.5.10' AND
			RPMTestedRelease = '6' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

