--
-- OVAL-id: OVAL704
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-0825' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 Server is installed
	(SELECT 'Windows 2000 Server is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0')

	AND EXISTS
		-- Windows server product option
		(SELECT 'Windows server product option' FROM Placeholder WHERE

		EXISTS
			-- this is an NT Server (stand-alone)

			(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%ServerNT%')

		OR EXISTS
			-- this is an NT Server (domain controller)

			(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductType' AND
				EntryValue LIKE '%LanmanNT%')))

AND EXISTS

	-- the version of wins.exe is less than 5.0.2195.6870

	(SELECT 'the version of wins.exe is less than 5.0.2195.6870' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\wins.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6870))))))

AND NOT EXISTS

	-- the patch kb830352 is installed (Hotfix key)

	(SELECT 'the patch kb830352 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB830352' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- the wins service is enabled

	(SELECT 'the wins service is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\wins' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

