--
-- OVAL-id: OVAL699
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0822' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND EXISTS

	-- a vulnerable version of fp30reg.dll or fp4areg.dll exists
	(SELECT 'a vulnerable version of fp30reg.dll or fp4areg.dll exists' FROM Placeholder WHERE

	EXISTS
		-- the version of fp4areg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp4areg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp4areg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523))))))

	OR EXISTS
		-- the version of fp30reg.dll is less than 4.0.02.7523

		(SELECT 'the version of fp30reg.dll is less than 4.0.02.7523' FROM Windows_FileAttributes WHERE
			FilePath = (SELECT EntryValue || '\Microsoft Shared\web server extensions\40\bin\fp30reg.dll' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion' AND
				EntryName = 'CommonFilesDir') AND
			(Version1 < 4 OR (Version1 = 4 AND
			(Version2 < 00 OR (Version2 = 00 AND
			(Version3 < 02 OR Version3 = 02 AND
			Version4 < 7523)))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- FrontPage Server Extensions 2000 are enabled (WinNT)

	(SELECT 'FrontPage Server Extensions 2000 are enabled (WinNT)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Shared Tools\Web Server Extensions\Setup Packages' AND
		EntryName = 'FrontPage 2000 Server Extensions SR')

--
-- ### END VULNERABLE CONFIGURATION
;

