--
-- OVAL-id: OVAL664
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0434' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- xpdf version is less than 2.0.1-11

	(SELECT 'xpdf version is less than 2.0.1-11' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'xpdf' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '2.0.1' AND
		RPMTestedRelease = '11' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- xpdf is executable
	(SELECT 'xpdf is executable' FROM Placeholder WHERE

	EXISTS
		-- xpdf is executable

		(SELECT 'xpdf is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/xpdf' AND
			UEXEC = '1')

	OR EXISTS
		-- xpdf is executable

		(SELECT 'xpdf is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/xpdf' AND
			GEXEC = '1')

	OR EXISTS
		-- xpdf is executable

		(SELECT 'xpdf is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/xpdf' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

