--
-- OVAL-id: OVAL57
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2003-1328' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 6.0 Installed

	(SELECT 'Internet Explorer 6.0 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '6.0.2600.0000')

AND EXISTS

	-- the version of mshtml.dll is less than 6.0.2723.2500

	(SELECT 'the version of mshtml.dll is less than 6.0.2723.2500' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 6 OR (Version1 = 6 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2723 OR Version3 = 2723 AND
		Version4 < 2500))))))

AND NOT EXISTS

	-- the patch q810847 is installed (Installed Components key)

	(SELECT 'the patch q810847 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{C34F4917-ED43-439f-9023-97B0024A2B3B}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q813489 is installed (Installed Components key)

	(SELECT 'the patch q813489 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{F9C174E3-3E87-40bc-AA94-B8974F2B9222}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q818529 is installed (Installed Components key)

	(SELECT 'the patch q818529 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{f5de1b93-9d38-416b-b09e-aa85a8e84309}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q822925 is installed (Installed Components key)

	(SELECT 'the patch q822925 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{377483c2-e4b4-4ee8-b577-9aed264c8735}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q828750 is installed (Installed Components key)

	(SELECT 'the patch q828750 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{96543d59-497a-4801-a1f3-5936aacaf7b1}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

AND NOT EXISTS

	-- the patch q824145 is installed (Installed Components key)

	(SELECT 'the patch q824145 is installed (Installed Components key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Active Setup\Installed Components\{057997dd-71e4-43cc-b161-3f8180691a9e}' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

