--
-- OVAL-id: OVAL569
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0440' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- wl version is less than 2.10.1-1.1

		(SELECT 'wl version is less than 2.10.1-1.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'wl' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.10.1' AND
			RPMTestedRelease = '1.1' AND
			RPMInstalledVersion = 'earlier')

	OR EXISTS
		-- wl-xemacs version is less than 2.10.1-1.1

		(SELECT 'wl-xemacs version is less than 2.10.1-1.1' FROM RedHat_RPMVersionCompare WHERE
			RPMName = 'wl-xemacs' AND
			RPMTestedEpoch = 'NULL' AND
			RPMTestedVersion = '2.10.1' AND
			RPMTestedRelease = '1.1' AND
			RPMInstalledVersion = 'earlier'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Vulnerable Config
	(SELECT 'Vulnerable Config' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/emacs is executable
		(SELECT '/usr/bin/emacs is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/emacs is executable

			(SELECT '/usr/bin/emacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/emacs' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/emacs is executable

			(SELECT '/usr/bin/emacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/emacs' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/emacs is executable

			(SELECT '/usr/bin/emacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/emacs' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/xemacs is executable
		(SELECT '/usr/bin/xemacs is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/xemacs is executable

			(SELECT '/usr/bin/xemacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xemacs' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/xemacs is executable

			(SELECT '/usr/bin/xemacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xemacs' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/xemacs is executable

			(SELECT '/usr/bin/xemacs is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/xemacs' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

