--
-- OVAL-id: OVAL564
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0196' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- samba version is less than 2.2.7a-8.9.0

	(SELECT 'samba version is less than 2.2.7a-8.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'samba' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '2.2.7a' AND
		RPMTestedRelease = '8.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smbd is listening on the network

	(SELECT 'smbd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smbd%')

--
-- ### END VULNERABLE CONFIGURATION
;

