--
-- OVAL-id: OVAL503
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0721' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- pine version is less than 4.44-19.90.0

	(SELECT 'pine version is less than 4.44-19.90.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'pine' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '4.44' AND
		RPMTestedRelease = '19.90.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/pine is executable
	(SELECT '/usr/bin/pine is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/pine is executable

		(SELECT '/usr/bin/pine is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/pine' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

