--
-- OVAL-id: OVAL478
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0819' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- ISA Server 2000 is installed

	(SELECT 'ISA Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Microsoft ISA Server' AND
		EntryName = 'VersionMajor' AND
		EntryValue = '3')

AND EXISTS

	-- the version of h32fltr.dll is less than 3.0.1200.291

	(SELECT 'the version of h32fltr.dll is less than 3.0.1200.291' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'h323fltr.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc' AND
			EntryName = 'InstallDirectory') AND
		(Version1 < 3 OR (Version1 = 3 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1200 OR Version3 = 1200 AND
		Version4 < 291))))))

AND NOT EXISTS

	-- the patch q816458 is installed

	(SELECT 'the patch q816458 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\Hotfixes\SP1\291' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- H.323 filter is enabled

	(SELECT 'H.323 filter is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Fpc\Arrays\{%}\Extensions\Proxy-Plugins\{FE440D49-AB26-11D2-A101-00C04FB6CFB6}' AND
		EntryName = 'msFPCEnabled' AND
		EntryValue = '1')

AND EXISTS

	-- Microsoft Firewall Service is not disabled

	(SELECT 'Microsoft Firewall Service is not disabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Fwsrv' AND
		EntryName = 'Start' AND
		EntryValue != '4')

--
-- ### END VULNERABLE CONFIGURATION
;

