--
-- OVAL-id: OVAL443
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0252' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- nfs-utils version is less than 1.0.1-3.9

	(SELECT 'nfs-utils version is less than 1.0.1-3.9' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'nfs-utils' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.0.1' AND
		RPMTestedRelease = '3.9' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- rpc.mountd listens on the network

	(SELECT 'rpc.mountd listens on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%rpc.mountd%')

--
-- ### END VULNERABLE CONFIGURATION
;

