--
-- OVAL-id: OVAL4254
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0543' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 8 or 9 installed
	(SELECT 'Solaris 8 or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 113505-02 or later installed

	(SELECT 'Patch 113505-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113505' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 113508-02 or later installed

	(SELECT 'Patch 113508-02 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113508' AND
		PatchVersion >= '02')

AND NOT EXISTS

	-- Patch 115054-01 or later installed

	(SELECT 'Patch 115054-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115054' AND
		PatchVersion >= '01')

AND NOT EXISTS

	-- Patch 115055-01 or later installed

	(SELECT 'Patch 115055-01 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '115055' AND
		PatchVersion >= '01')

AND EXISTS

	-- SunCluster Component SUNWscvw installed

	(SELECT 'SunCluster Component SUNWscvw installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWscvw')

AND EXISTS

	-- Apache (SUNWapchu) installed

	(SELECT 'Apache (SUNWapchu) installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWapchu')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Apache running with SunPlex Manager config

	(SELECT 'Apache running with SunPlex Manager config' FROM Solaris_PSInfo WHERE
		Command LIKE '/usr/apache/bin/httpd%SUNWscvw/conf/httpd_conf%')

--
-- ### END VULNERABLE CONFIGURATION
;

