--
-- OVAL-id: OVAL3606
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0681' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Sendmail installed

	(SELECT 'Sendmail installed' FROM Solaris_Pkginfo WHERE
		Pkginst = 'SUNWsndmr')

AND EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND NOT EXISTS

	-- Patch 107684-11 or later installed

	(SELECT 'Patch 107684-11 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107684' AND
		PatchVersion >= '11')

AND NOT EXISTS

	-- Patch 110615-11 or later installed

	(SELECT 'Patch 110615-11 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '110615' AND
		PatchVersion >= '11')

AND NOT EXISTS

	-- Patch 113575-05 or later installed

	(SELECT 'Patch 113575-05 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '113575' AND
		PatchVersion >= '05')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Sendmail running

	(SELECT 'Sendmail running' FROM Solaris_PSInfo WHERE
		Command LIKE '%sendmail %')

AND EXISTS

	-- Sendmail has recipient or final rulesets

	-- unknown_test
	-- NOTE: egrep "^[Srecipient=2|S2]|^[^#]*\$>2|^[^#]*\$>recipient|^[^#]*\$>4|^[^#]*\$>final" /etc/mail/sendmail.cf True if any lines returned

	(SELECT 'unknown_test' FROM Placeholder WHERE 1 = 1)

--
-- ### END VULNERABLE CONFIGURATION
;

