--
-- OVAL-id: OVAL2753
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0572' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of grpconv.exe (system32) is less than 5.0.2195.6966

	(SELECT 'the version of grpconv.exe (system32) is less than 5.0.2195.6966' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\grpconv.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6966))))))

AND NOT EXISTS

	-- the patch q841356 is installed (Hotfix key)

	(SELECT 'the patch q841356 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841356' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

