--
-- OVAL-id: OVAL235
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0230' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- SQL Server 2000 is installed

	(SELECT 'SQL Server 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\MSSQLServer\MSSQLServer\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '8.00.194')

AND EXISTS

	-- File console.exe version3 is less than 818

	(SELECT 'File console.exe version3 is less than 818' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'console.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- File dbmslpcn.dll version3 is less than 818

	(SELECT 'File dbmslpcn.dll version3 is less than 818' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\dbmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WindowsNT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlmap70.dll version3 is less than 811

	(SELECT 'File sqlmap70.dll version3 is less than 811' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlmap70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 811 OR Version3 = 811 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlrepss.dll version3 is less than 765

	(SELECT 'File sqlrepss.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlrepss.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of sqlservr.exe is less than 2000.80.818.0

	(SELECT 'the version of sqlservr.exe is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlservr.exe' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssmslpcn.dll is less than 2000.80.818.0

	(SELECT 'the version of ssmslpcn.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssmslpcn.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnetlib.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnetlib.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnetlib.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ssnmpn70.dll is less than 2000.80.818.0

	(SELECT 'the version of ssnmpn70.dll is less than 2000.80.818.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ssnmpn70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 818 OR Version3 = 818 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of ums.dll is less than 2000.80.816.0

	(SELECT 'the version of ums.dll is less than 2000.80.816.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'ums.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 816 OR Version3 = 816 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of odsole70.dll is less than 2000.80.800.0

	(SELECT 'the version of odsole70.dll is less than 2000.80.800.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'odsole70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 800 OR Version3 = 800 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of xpweb70.dll is less than 2000.80.778.0

	(SELECT 'the version of xpweb70.dll is less than 2000.80.778.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'xpweb70.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 778 OR Version3 = 778 AND
		Version4 < 0))))))

AND EXISTS

	-- File msgprox.dll version3 is less than 765

	(SELECT 'File msgprox.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'msgprox.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- the version of replprov.dll is less than 2000.80.798.0

	(SELECT 'the version of replprov.dll is less than 2000.80.798.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replprov.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server' AND
			EntryName = 'SharedCode') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 798 OR Version3 = 798 AND
		Version4 < 0))))))

AND EXISTS

	-- File replrec.dll version3 is less than 765

	(SELECT 'File replrec.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'replrec.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

AND EXISTS

	-- File sqlvdi.dll version3 is less than 765

	(SELECT 'File sqlvdi.dll version3 is less than 765' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || 'sqlvdi.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\sqlservr.exe' AND
			EntryName = 'Path') AND
		(Version1 < 2000 OR (Version1 = 2000 AND
		(Version2 < 80 OR (Version2 = 80 AND
		(Version3 < 765 OR Version3 = 765 AND
		Version4 < 0))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

