--
-- OVAL-id: OVAL2166
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0210' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- the patch kb841872 is installed

	(SELECT 'the patch kb841872 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB841872' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Version check for psxss.exe on NT Workstation, Server 4.0 and NT Terminal Server
	(SELECT 'Version check for psxss.exe on NT Workstation, Server 4.0 and NT Terminal Server' FROM Placeholder WHERE

	EXISTS
		-- This is an NT Terminal Server and the version of psxss.exe is less than 4.0.1381.33567
		(SELECT 'This is an NT Terminal Server and the version of psxss.exe is less than 4.0.1381.33567' FROM Placeholder WHERE

		EXISTS
			-- the version of psxss.exe is less than 4.0.1381.33567

			(SELECT 'the version of psxss.exe is less than 4.0.1381.33567' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\psxss.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 33567))))))

		AND EXISTS
			-- this is an NT Terminal Server

			(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
				EntryName = 'ProductSuite' AND
				EntryValue = 'Terminal Server'))

	OR EXISTS
		-- The version of psxss.exe is less than 4.0.1381.7269 on either NT Workstation or NT Server 4.0
		(SELECT 'The version of psxss.exe is less than 4.0.1381.7269 on either NT Workstation or NT Server 4.0' FROM Placeholder WHERE

		EXISTS
			-- This is an NT Workstation or Windows NT Server 4.0 is installed
			(SELECT 'This is an NT Workstation or Windows NT Server 4.0 is installed' FROM Placeholder WHERE

			EXISTS
				-- Windows NT Server 4.0 is installed
				(SELECT 'Windows NT Server 4.0 is installed' FROM Placeholder WHERE

				EXISTS
					-- Windows NT 4.0 is installed

					(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CurrentVersion' AND
						EntryValue = '4.0')

				AND EXISTS
					-- Windows server product option
					(SELECT 'Windows server product option' FROM Placeholder WHERE

					EXISTS
						-- this is an NT Server (stand-alone)

						(SELECT 'this is an NT Server (stand-alone)' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
							EntryName = 'ProductType' AND
							EntryValue LIKE '%ServerNT%')

					OR EXISTS
						-- this is an NT Server (domain controller)

						(SELECT 'this is an NT Server (domain controller)' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
							EntryName = 'ProductType' AND
							EntryValue LIKE '%LanmanNT%')))

			OR EXISTS
				-- this is an NT Workstation

				(SELECT 'this is an NT Workstation' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
					EntryName = 'ProductType' AND
					EntryValue = 'WinNT'))

		AND EXISTS
			-- the version of psxss.exe is less than 4.0.1381.7269

			(SELECT 'the version of psxss.exe is less than 4.0.1381.7269' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\psxss.exe' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 4 OR (Version1 = 4 AND
				(Version2 < 0 OR (Version2 = 0 AND
				(Version3 < 1381 OR Version3 = 1381 AND
				Version4 < 7269))))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- POSIX is enabled

	(SELECT 'POSIX is enabled' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Subsystem' AND
		EntryName = 'Posix')

--
-- ### END VULNERABLE CONFIGURATION
;

