--
-- OVAL-id: OVAL2114
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0209' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND NOT EXISTS

	-- the patch KB840987 is installed (Hotfix key)

	(SELECT 'the patch KB840987 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB840987' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- the version of gdi32.dll is less than 5.0.2195.6945

	(SELECT 'the version of gdi32.dll is less than 5.0.2195.6945' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\gdi32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 2195 OR Version3 = 2195 AND
		Version4 < 6945))))))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

