--
-- OVAL-id: OVAL2016
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0203' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Exchange 5.5 with SP4 Installed

	(SELECT 'Exchange 5.5 with SP4 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Exchange\Setup' AND
		EntryName = 'ServicePackBuild' AND
		EntryValue = '2653')

AND EXISTS

	-- the version of cdo.dll is less than 5.5.2558.10

	(SELECT 'the version of cdo.dll is less than 5.5.2558.10' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\cdo.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 5 OR (Version2 = 5 AND
		(Version3 < 2558 OR Version3 = 2558 AND
		Version4 < 10))))))

AND NOT EXISTS

	-- the  patch kb842436 is installed

	(SELECT 'the  patch kb842436 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Updates\Exchange Server 5.5\SP5\842436a' AND
		EntryName = 'IsInstalled' AND
		EntryValue = '2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Outlook Web Access exists

	(SELECT 'Outlook Web Access exists' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\MSExchangeweb')

--
-- ### END VULNERABLE CONFIGURATION
;

