--
-- OVAL-id: OVAL190
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2002-0699' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows 2000 is installed

	(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.0')

AND EXISTS

	-- the version of xenroll.dll is less than 5.131.3659.0

	(SELECT 'the version of xenroll.dll is less than 5.131.3659.0' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\xenroll.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 131 OR (Version2 = 131 AND
		(Version3 < 3659 OR Version3 = 3659 AND
		Version4 < 0))))))

AND NOT EXISTS

	-- Patch Q323172 Installed

	(SELECT 'Patch Q323172 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q323172' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- SP4 or later Installed

	(SELECT 'SP4 or later Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue >= 'Service Pack 4')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- ActiveX Enabled
	(SELECT 'ActiveX Enabled' FROM Placeholder WHERE

	EXISTS
		-- use machine settings rather than individual user settings

		(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
			EntryName = 'Security_HKLM_only' AND
			EntryValue = '1')

	AND EXISTS
		-- ActiveX Enabled In At Least One Zone

		(SELECT 'ActiveX Enabled In At Least One Zone' FROM Windows_RegistryKeys WHERE
			RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
			EntryName = '1200' AND
			EntryValue = '0'))

--
-- ### END VULNERABLE CONFIGURATION
;

