--
-- OVAL-id: OVAL185
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0660' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of cryptui.dll exists
	(SELECT 'a vulnerable version of cryptui.dll exists' FROM Placeholder WHERE

	EXISTS
		-- no service pack is installed and cryptui.dll is less than 5.131.2600.117
		(SELECT 'no service pack is installed and cryptui.dll is less than 5.131.2600.117' FROM Placeholder WHERE

		NOT EXISTS
			-- a Win2K/XP/2003 service pack is installed

			(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion')

		AND EXISTS
			-- the version of cryptui.dll is less than 5.131.2600.117

			(SELECT 'the version of cryptui.dll is less than 5.131.2600.117' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\cryptui.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 131 OR (Version2 = 131 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 117)))))))

	OR EXISTS
		-- service pack 1 is installed and cryptui.dll is less than 5.131.2600.1243
		(SELECT 'service pack 1 is installed and cryptui.dll is less than 5.131.2600.1243' FROM Placeholder WHERE

		EXISTS
			-- Win2K/XP/2003 service pack 1 is installed

			(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
				EntryName = 'CSDVersion' AND
				EntryValue = 'Service Pack 1')

		AND EXISTS
			-- the version of cryptui.dll is less than 5.131.2600.1243

			(SELECT 'the version of cryptui.dll is less than 5.131.2600.1243' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\cryptui.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 131 OR (Version2 = 131 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1243))))))))

AND NOT EXISTS

	-- Patch WindowsXP-KB823182-x86-ENU Installed

	(SELECT 'Patch WindowsXP-KB823182-x86-ENU Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB823182' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- downloading of signed ActiveX controls is enabled
	(SELECT 'downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

	EXISTS
		-- current user settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'current user settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		NOT EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the local machine

			(SELECT 'downloading of signed ActiveX controls is enabled for the local machine' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3'))

	AND EXISTS
		-- local machine settings are being used and the downloading of signed ActiveX controls is enabled
		(SELECT 'local machine settings are being used and the downloading of signed ActiveX controls is enabled' FROM Placeholder WHERE

		EXISTS
			-- use machine settings rather than individual user settings

			(SELECT 'use machine settings rather than individual user settings' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings' AND
				EntryName = 'Security_HKLM_only' AND
				EntryValue = '1')

		AND EXISTS
			-- downloading of signed ActiveX controls is enabled for the current user

			(SELECT 'downloading of signed ActiveX controls is enabled for the current user' FROM Windows_RegistryKeys WHERE
				RegistryKey IN ('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\0', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\1', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\2', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\3', 
'HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\Zones\4') AND
				EntryName = '1001' AND
				EntryValue != '3')))

--
-- ### END VULNERABLE CONFIGURATION
;

