--
-- OVAL-id: OVAL177
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-0679' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Solaris 7 Installed

	(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
		OSName = 'SunOS' AND
		OSRelease = '5.7')

AND EXISTS

	-- File rpc.ttdbserverd exists

	(SELECT 'File rpc.ttdbserverd exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/rpc.ttdbserverd')

AND NOT EXISTS

	-- Patch 107893-20 or later installed

	(SELECT 'Patch 107893-20 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107893' AND
		PatchVersion >= '20')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- inetd.conf contains rpc.ttdbserverd

	(SELECT 'inetd.conf contains rpc.ttdbserverd' FROM Solaris_InetdConf WHERE
		ServerProgram = '/usr/dt/bin/rpc.ttdbserverd')

AND EXISTS

	-- inetd running

	(SELECT 'inetd running' FROM Solaris_PSInfo WHERE
		Command LIKE '%inetd%' AND
		UserID = 'root')

AND EXISTS

	-- File rpc.ttdbserverd executable
	(SELECT 'File rpc.ttdbserverd executable' FROM Placeholder WHERE

	EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			UEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			GEXEC = '1')

	OR EXISTS
		-- File rpc.ttdbserverd executable

		(SELECT 'File rpc.ttdbserverd executable' FROM Solaris_FileAttributes WHERE
			FilePath = '/usr/dt/bin/rpc.ttdbserverd' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

