--
-- OVAL-id: OVAL1436
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0368' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- File /usr/dt/bin/dtlogin exists

	(SELECT 'File /usr/dt/bin/dtlogin exists' FROM Solaris_FileAttributes WHERE
		FilePath = '/usr/dt/bin/dtlogin')

AND EXISTS

	-- Solaris 7,8,or 9 installed
	(SELECT 'Solaris 7,8,or 9 installed' FROM Placeholder WHERE

	EXISTS
		-- Solaris 8 Installed

		(SELECT 'Solaris 8 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.8')

	OR EXISTS
		-- Solaris 7 Installed

		(SELECT 'Solaris 7 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.7')

	OR EXISTS
		-- Solaris 9 Installed

		(SELECT 'Solaris 9 Installed' FROM Solaris_Uname WHERE
			OSName = 'SunOS' AND
			OSRelease = '5.9'))

AND EXISTS

	-- Patch 108919-21 or later installed

	(SELECT 'Patch 108919-21 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '108919' AND
		PatchVersion >= '21')

AND EXISTS

	-- Patch 112807-09 or later installed

	(SELECT 'Patch 112807-09 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '112807' AND
		PatchVersion >= '09')

AND EXISTS

	-- Patch 107180-31 or later installed

	(SELECT 'Patch 107180-31 or later installed' FROM Solaris_Patches WHERE
		PatchBase = '107180' AND
		PatchVersion >= '31')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- dtlogin running

	(SELECT 'dtlogin running' FROM Solaris_PSInfo WHERE
		Command LIKE '%dtlogin%')

--
-- ### END VULNERABLE CONFIGURATION
;

