--
-- OVAL-id: OVAL1054
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0806' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- a vulnerable version of msgina.dll exists
	(SELECT 'a vulnerable version of msgina.dll exists' FROM Placeholder WHERE

	EXISTS
		-- 32-bit version of Windows and a vulnerable version of msgina.dll exists
		(SELECT '32-bit version of Windows and a vulnerable version of msgina.dll exists' FROM Placeholder WHERE

		EXISTS
			-- 32-Bit version of Windows is installed

			(SELECT '32-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'x86')

		AND EXISTS
			-- a vulnerable version of msgina.dll exists depending on service pack level
			(SELECT 'a vulnerable version of msgina.dll exists depending on service pack level' FROM Placeholder WHERE

			EXISTS
				-- no service pack is installed and msgina.dll is less than 5.1.2600.128
				(SELECT 'no service pack is installed and msgina.dll is less than 5.1.2600.128' FROM Placeholder WHERE

				NOT EXISTS
					-- a Win2K/XP/2003 service pack is installed

					(SELECT 'a Win2K/XP/2003 service pack is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion')

				AND EXISTS
					-- the version of msgina.dll is less than 5.1.2600.128

					(SELECT 'the version of msgina.dll is less than 5.1.2600.128' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\msgina.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 128)))))))

			OR EXISTS
				-- service pack 1 is installed and msgina.dll is less than 5.1.2600.1343
				(SELECT 'service pack 1 is installed and msgina.dll is less than 5.1.2600.1343' FROM Placeholder WHERE

				EXISTS
					-- Win2K/XP/2003 service pack 1 is installed

					(SELECT 'Win2K/XP/2003 service pack 1 is installed' FROM Windows_RegistryKeys WHERE
						RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
						EntryName = 'CSDVersion' AND
						EntryValue = 'Service Pack 1')

				AND EXISTS
					-- the version of msgina.dll is less than 5.1.2600.1343

					(SELECT 'the version of msgina.dll is less than 5.1.2600.1343' FROM Windows_FileAttributes WHERE
						FilePath = (SELECT EntryValue || '\system32\msgina.dll' FROM Windows_RegistryKeys WHERE
							RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
							EntryName = 'SystemRoot') AND
						(Version1 < 5 OR (Version1 = 5 AND
						(Version2 < 1 OR (Version2 = 1 AND
						(Version3 < 2600 OR Version3 = 2600 AND
						Version4 < 1343)))))))))

	OR EXISTS
		-- 64-bit version of Windows and msgina.dll is less than 5.1.2600.1343
		(SELECT '64-bit version of Windows and msgina.dll is less than 5.1.2600.1343' FROM Placeholder WHERE

		EXISTS
			-- 64-Bit version of Windows is installed

			(SELECT '64-Bit version of Windows is installed' FROM Windows_RegistryKeys WHERE
				RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Environment' AND
				EntryName = 'PROCESSOR_ARCHITECTURE' AND
				EntryValue = 'ia64')

		AND EXISTS
			-- the version of msgina.dll is less than 5.1.2600.1343

			(SELECT 'the version of msgina.dll is less than 5.1.2600.1343' FROM Windows_FileAttributes WHERE
				FilePath = (SELECT EntryValue || '\system32\msgina.dll' FROM Windows_RegistryKeys WHERE
					RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
					EntryName = 'SystemRoot') AND
				(Version1 < 5 OR (Version1 = 5 AND
				(Version2 < 1 OR (Version2 = 1 AND
				(Version3 < 2600 OR Version3 = 2600 AND
				Version4 < 1343))))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND EXISTS

	-- Windows XP (sp1 or earlier) is installed
	(SELECT 'Windows XP (sp1 or earlier) is installed' FROM Placeholder WHERE

	EXISTS
		-- Windows XP is installed

		(SELECT 'Windows XP is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.1')

	AND NOT EXISTS
		-- Win2K/XP/2003 service pack 2 (or later) is installed

		(SELECT 'Win2K/XP/2003 service pack 2 (or later) is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CSDVersion' AND
			EntryValue IN ('Service Pack 2', 'Service Pack 3', 'Service Pack 4', 'Service Pack 5', 'Service Pack 6', 'Service Pack 7', 'Service Pack 8', 'Service Pack 9','Service Pack 10')))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- machine is a member of a domain

	(SELECT 'machine is a member of a domain' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Netlogon' AND
		EntryName = 'Start' AND
		EntryValue = '2')

--
-- ### END VULNERABLE CONFIGURATION
;

