--
-- OVAL-id: OVAL1024
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-1999-0621' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT or 2000 Installed
	(SELECT 'Windows NT or 2000 Installed' FROM Placeholder WHERE

	EXISTS
		-- Windows NT 4.0 is installed

		(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '4.0')

	OR EXISTS
		-- Windows 2000 is installed

		(SELECT 'Windows 2000 is installed' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'CurrentVersion' AND
			EntryValue = '5.0'))

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- NetBIOS enabled
	(SELECT 'NetBIOS enabled' FROM Placeholder WHERE

	EXISTS
		-- NetBIOS Bind not disabled

		(SELECT 'NetBIOS Bind not disabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NetBIOS\Linkage' AND
			EntryName = 'Bind' AND
			EntryValue != '0')

	AND EXISTS
		-- NetBIOS Export not disabled

		(SELECT 'NetBIOS Export not disabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NetBIOS\Linkage' AND
			EntryName = 'Export' AND
			EntryValue != '0')

	AND EXISTS
		-- NetBIOS Route not disabled

		(SELECT 'NetBIOS Route not disabled' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NetBIOS\Linkage' AND
			EntryName = 'Route' AND
			EntryValue != '0'))

--
-- ### END VULNERABLE CONFIGURATION
;

