DROP TABLE Windows_AccountPrivileges;
DROP TABLE Windows_FileAttributes;
DROP TABLE Windows_FileEffectiveRights;
DROP TABLE Windows_MetabaseKeys;
DROP TABLE Windows_PSInfo;
DROP TABLE Windows_RegistryKeys;
DROP TABLE Windows_RegKeyEffectiveRights;


CREATE TABLE Windows_AccountPrivileges
	(AccountName varchar(128),
	AccountDomain varchar(128),
	AccountSID varchar(64),
	SeAssignPrimaryTokenPrivilege integer,
	SeAuditPrivilege integer,
	SeBackupPrivilege integer,
	SeChangeNotifyPrivilege integer,
	SeCreateGlobalPrivilege integer,
	SeCreatePagefilePrivilege integer,
	SeCreatePermanentPrivilege integer,
	SeCreateTokenPrivilege integer,
	SeDebugPrivilege integer,
	SeEnableDelegationPrivilege integer,
	SeImpersonatePrivilege integer,
	SeIncreaseBasePriorityPrivilege integer,
	SeIncreaseQuotaPrivilege integer,
	SeLoadDriverPrivilege integer,
	SeLockMemoryPrivilege integer,
	SeUnsolicitedInputPrivilege integer,
	SeMachineAccountPrivilege integer,
	SeManageVolumePrivilege integer,
	SeProfileSingleProcessPrivilege integer,
	SeRemoteShutdownPrivilege integer,
	SeRestorePrivilege integer,
	SeSecurityPrivilege integer,
	SeShutdownPrivilege integer,
	SeSyncAgentPrivilege integer,
	SeSystemEnvironmentPrivilege integer,
	SeSystemProfilePrivilege integer,
	SeSystemtimePrivilege integer,
	SeTcbPrivilege integer,
	SeTakeOwnershipPrivilege integer,
	SeUndockPrivilege integer,
	SeBatchLogonRight integer,
	SeDenyInteractiveLogonRight integer,
	SeDenyNetworkLogonRight integer,
	SeDenyBatchLogonRight integer,
	SeDenyServiceLogonRight integer,
	SeDenyRemoteInteractiveLogonRight integer,
	SeInteractiveLogonRight integer,
	SeNetworkLogonRight integer,
	SeRemoteInteractiveLogonRight integer,
	SeServiceLogonRight integer);


CREATE TABLE Windows_FileAttributes
	(FilePath varchar(1024),
	Owner varchar(128),
	Filesize integer,
	Atime integer,
	Ctime integer,
	Mtime integer,
	MSChecksum varchar(64),
	MD5 varchar(64),
	Version1 integer,
	Version2 integer,
	Version3 integer,
	Version4 integer,
	FileType varchar(32));


CREATE TABLE Windows_FileEffectiveRights
	(FilePath varchar(1024),
	TrusteeName varchar(128),
	TrusteeDomain varchar(128),
	TrusteeSID varchar(64),
	STANDARD_DELETE integer,
	STANDARD_READ_CONTROL integer,
	STANDARD_WRITE_DAC integer,
	STANDARD_WRITE_OWNER integer,
	STANDARD_SYNCHRONIZE integer,
	ACCESS_SYSTEM_SECURITY integer,
	GENERIC_READ integer,
	GENERIC_WRITE integer,
	GENERIC_EXECUTE integer,
	GENERIC_ALL integer,
	FILE_READ_DATA integer,
	FILE_WRITE_DATA integer,
	FILE_APPEND_DATA integer,
	FILE_READ_EA integer,
	FILE_WRITE_EA integer,
	FILE_EXECUTE integer,
	FILE_DELETE_CHILD integer,
	FILE_READ_ATTRIBUTES integer,
	FILE_WRITE_ATTRIBUTES integer);


CREATE TABLE Windows_MetabaseKeys
	(MetabaseKey varchar(1024),
	Id integer,
	Name varchar(128),
	UserType varchar(32),
	DataType varchar(32),
	Data varchar(128),
	METADATA_NO_ATTRIBUTES integer,
	METADATA_INHERIT integer,
	METADATA_PARTIAL_PATH integer,
	METADATA_SECURE integer,
	METADATA_REFERENCE integer,
	METADATA_VOLATILE integer,
	METADATA_ISINHERITED integer,
	METADATA_INSERT_PATH integer,
	METADATA_LOCAL_MACHINE_ONLY integer);


CREATE TABLE Windows_PSInfo
	(PID integer,
	PPID integer,
	Priority integer,
	ImagePath varchar(1024),
	CommandLine varchar(1024),
	CurrentDir varchar(1024));


CREATE TABLE Windows_RegistryKeys
	(RegistryKey varchar(1024),
	EntryName varchar(128),
	EntryType varchar(32),
	EntryValue varchar(1024));


CREATE TABLE Windows_RegKeyEffectiveRights
	(RegistryKey varchar(1024),
	TrusteeName varchar(128),
	TrusteeDomain varchar(128),
	TrusteeSID varchar(64),
	STANDARD_DELETE integer,
	STANDARD_READ_CONTROL integer,
	STANDARD_WRITE_DAC integer,
	STANDARD_WRITE_OWNER integer,
	STANDARD_SYNCHRONIZE integer,
	ACCESS_SYSTEM_SECURITY integer,
	GENERIC_READ integer,
	GENERIC_WRITE integer,
	GENERIC_EXECUTE integer,
	GENERIC_ALL integer,
	KEY_QUERY_VALUE integer,
	KEY_SET_VALUE integer,
	KEY_CREATE_SUB_KEY integer,
	KEY_ENUMERATE_SUB_KEYS integer,
	KEY_NOTIFY integer,
	KEY_CREATE_LINK integer);
