--
-- OVAL-id: OVAL954
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0411' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- kdelibs version is less than 3.1.3-6.4

	(SELECT 'kdelibs version is less than 3.1.3-6.4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'kdelibs' AND
		RPMTestedEpoch = '6' AND
		RPMTestedVersion = '3.1.3' AND
		RPMTestedRelease = '6.4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- telnet, rlogin, ssh or kmail is executable
	(SELECT 'telnet, rlogin, ssh or kmail is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/telnet is executable
		(SELECT '/usr/bin/telnet is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/telnet is executable

			(SELECT '/usr/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/telnet' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/telnet is executable

			(SELECT '/usr/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/telnet' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/telnet is executable

			(SELECT '/usr/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/telnet' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/kerberos/bin/telnet is executable
		(SELECT '/usr/kerberos/bin/telnet is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/kerberos/bin/telnet is executable

			(SELECT '/usr/kerberos/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/telnet' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/telnet is executable

			(SELECT '/usr/kerberos/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/telnet' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/telnet is executable

			(SELECT '/usr/kerberos/bin/telnet is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/telnet' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/rlogin is executable
		(SELECT '/usr/bin/rlogin is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/rlogin is executable

			(SELECT '/usr/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rlogin' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/rlogin is executable

			(SELECT '/usr/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rlogin' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/rlogin is executable

			(SELECT '/usr/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/rlogin' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/kerberos/bin/rlogin is executable
		(SELECT '/usr/kerberos/bin/rlogin is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/kerberos/bin/rlogin is executable

			(SELECT '/usr/kerberos/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/rlogin' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/rlogin is executable

			(SELECT '/usr/kerberos/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/rlogin' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/kerberos/bin/rlogin is executable

			(SELECT '/usr/kerberos/bin/rlogin is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/kerberos/bin/rlogin' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/ssh is executable
		(SELECT '/usr/bin/ssh is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/ssh is executable

			(SELECT '/usr/bin/ssh is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ssh' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/ssh is executable

			(SELECT '/usr/bin/ssh is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ssh' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/ssh is executable

			(SELECT '/usr/bin/ssh is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/ssh' AND
				OEXEC = '1'))

	OR EXISTS
		-- /usr/bin/kmail is executable
		(SELECT '/usr/bin/kmail is executable' FROM Placeholder WHERE

		EXISTS
			-- /usr/bin/kmail is executable

			(SELECT '/usr/bin/kmail is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/kmail' AND
				UEXEC = '1')

		OR EXISTS
			-- /usr/bin/kmail is executable

			(SELECT '/usr/bin/kmail is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/kmail' AND
				GEXEC = '1')

		OR EXISTS
			-- /usr/bin/kmail is executable

			(SELECT '/usr/bin/kmail is executable' FROM RedHat_FileAttributes WHERE
				FilePath = '/usr/bin/kmail' AND
				OEXEC = '1')))

--
-- ### END VULNERABLE CONFIGURATION
;

