--
-- OVAL-id: OVAL904
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0907' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows Server 2003 is installed

	(SELECT 'Windows Server 2003 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '5.2')

AND EXISTS

	-- the version of helpctr.exe is less than 5.2.3790.125

	(SELECT 'the version of helpctr.exe is less than 5.2.3790.125' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\helpctr.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 2 OR (Version2 = 2 AND
		(Version3 < 3790 OR Version3 = 3790 AND
		Version4 < 125))))))

AND NOT EXISTS

	-- the patch kb835732 is installed

	(SELECT 'the patch kb835732 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB835732' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- the HCP Protocol is registered

	(SELECT 'the HCP Protocol is registered' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_CLASSES_ROOT\HCP')

--
-- ### END VULNERABLE CONFIGURATION
;

