--
-- OVAL-id: OVAL90
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2001-0151' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- IIS major version equals 5

	(SELECT 'IIS major version equals 5' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MajorVersion' AND
		EntryValue = '5')

AND EXISTS

	-- IIS minor version equals 0

	(SELECT 'IIS minor version equals 0' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\INetStp' AND
		EntryName = 'MinorVersion' AND
		EntryValue = '0')

AND EXISTS

	-- File %windir%\system32\inetsrv\httpext.dll version is less than 0.9.3940.20

	(SELECT 'File %windir%\system32\inetsrv\httpext.dll version is less than 0.9.3940.20' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\inetsrv\httpext.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 0 OR (Version1 = 0 AND
		(Version2 < 9 OR (Version2 = 9 AND
		(Version3 < 3940 OR Version3 = 3940 AND
		Version4 < 20))))))

AND NOT EXISTS

	-- Patch Q291845 Installed

	(SELECT 'Patch Q291845 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q291845' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q293826 Installed

	(SELECT 'Patch Q293826 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q293826' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q301625 Installed

	(SELECT 'Patch Q301625 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q301625' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q319733 Installed

	(SELECT 'Patch Q319733 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q319733' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q327696 Installed

	(SELECT 'Patch Q327696 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q327696' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Patch Q811114 Installed

	(SELECT 'Patch Q811114 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q811114' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

AND NOT EXISTS

	-- Win2K/XP/2003 service pack 2 is installed

	(SELECT 'Win2K/XP/2003 service pack 2 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CSDVersion' AND
		EntryValue = 'Service Pack 2')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND NOT EXISTS

	-- WebDav is disabled(for iis 5.0)

	(SELECT 'WebDav is disabled(for iis 5.0)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\W3SVC\Parameters' AND
		EntryName = 'DisableWebDAV' AND
		EntryValue = '1')

--
-- ### END VULNERABLE CONFIGURATION
;

