--
-- OVAL-id: OVAL869
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0935' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- net-snmp version is less than 5.0.9-2.30E.1

	(SELECT 'net-snmp version is less than 5.0.9-2.30E.1' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'net-snmp' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '5.0.9' AND
		RPMTestedRelease = '2.30E.1' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- snmpd is listening to the network

	(SELECT 'snmpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%snmpd%')

--
-- ### END VULNERABLE CONFIGURATION
;

