--
-- OVAL-id: OVAL828
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0973' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- mod_python version is less than 3.0.1-4

	(SELECT 'mod_python version is less than 3.0.1-4' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'mod_python' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.0.1' AND
		RPMTestedRelease = '4' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- httpd is listening to the network

	(SELECT 'httpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%httpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

