--
-- OVAL-id: OVAL827
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2004-0082' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat Enterprise 3 is installed

	(SELECT 'Red Hat Enterprise 3 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion LIKE '3_S%')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- samba version is less than 3.0.2-6.3E

	(SELECT 'samba version is less than 3.0.2-6.3E' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'samba' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '3.0.2' AND
		RPMTestedRelease = '6.3E' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- smbd is listening on the network

	(SELECT 'smbd is listening on the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%smbd%')

--
-- ### END VULNERABLE CONFIGURATION
;

