--
-- OVAL-id: OVAL818
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0006' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- gaim version is less than 0.75-0.9.0

	(SELECT 'gaim version is less than 0.75-0.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'gaim' AND
		RPMTestedEpoch = '1' AND
		RPMTestedVersion = '0.75' AND
		RPMTestedRelease = '0.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- /usr/bin/gaim is executable
	(SELECT '/usr/bin/gaim is executable' FROM Placeholder WHERE

	EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			UEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			GEXEC = '1')

	OR EXISTS
		-- /usr/bin/gaim is executable

		(SELECT '/usr/bin/gaim is executable' FROM RedHat_FileAttributes WHERE
			FilePath = '/usr/bin/gaim' AND
			OEXEC = '1'))

--
-- ### END VULNERABLE CONFIGURATION
;

