--
-- OVAL-id: OVAL7611
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2004-0845' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Internet Explorer 5.01 Service Pack 3 is installed

	(SELECT 'Internet Explorer 5.01 Service Pack 3 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer' AND
		EntryName = 'Version' AND
		EntryValue = '5.00.3502.1000')

AND EXISTS

	-- the version of mshtml.dll is less than 5.0.3821.2800

	(SELECT 'the version of mshtml.dll is less than 5.0.3821.2800' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\mshtml.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 5 OR (Version1 = 5 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 3821 OR Version3 = 3821 AND
		Version4 < 2800))))))

AND NOT EXISTS

	-- the patch kb834707-ie501sp3 is installed (Hotfix key)

	(SELECT 'the patch kb834707-ie501sp3 is installed (Hotfix key)' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\KB834707-ie501sp3-20040929.121357' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- Users not saving encrypted pages to disk  (DisableCachingOfSSLPages)

	(SELECT 'Users not saving encrypted pages to disk  (DisableCachingOfSSLPages)' FROM Windows_RegistryKeys WHERE
		RegistryKey LIKE '%HKEY_USERS\S-[-0-9]+\Software\Microsoft\Windows\CurrentVersion\Internet Settings' AND
		EntryName = 'DisableCachingOfSSLPages' AND
		EntryValue != '1')

--
-- ### END VULNERABLE CONFIGURATION
;

