--
-- OVAL-id: OVAL681
--
-- SchemaVersion: 3.00
--

SELECT 'CVE-2002-1230' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Windows NT 4.0 is installed

	(SELECT 'Windows NT 4.0 is installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
		EntryName = 'CurrentVersion' AND
		EntryValue = '4.0')

AND NOT EXISTS

	-- this is an NT Terminal Server

	(SELECT 'this is an NT Terminal Server' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\ProductOptions' AND
		EntryName = 'ProductSuite' AND
		EntryValue = 'Terminal Server')

AND EXISTS

	-- the version of user32.dll is less than 4.0.1381.7177

	(SELECT 'the version of user32.dll is less than 4.0.1381.7177' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\user32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7177))))))

AND EXISTS

	-- the version of gdi32.dll is less than 4.0.1381.7177

	(SELECT 'the version of gdi32.dll is less than 4.0.1381.7177' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\gdi32.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7177))))))

AND EXISTS

	-- the version of winsrv.dll is less than 4.0.1381.7202

	(SELECT 'the version of winsrv.dll is less than 4.0.1381.7202' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\winsrv.dll' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7202))))))

AND EXISTS

	-- the version of win32k.sys is less than 4.0.1381.7207

	(SELECT 'the version of win32k.sys is less than 4.0.1381.7207' FROM Windows_FileAttributes WHERE
		FilePath = (SELECT EntryValue || '\system32\win32k.sys' FROM Windows_RegistryKeys WHERE
			RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion' AND
			EntryName = 'SystemRoot') AND
		(Version1 < 4 OR (Version1 = 4 AND
		(Version2 < 0 OR (Version2 = 0 AND
		(Version3 < 1381 OR Version3 = 1381 AND
		Version4 < 7207))))))

AND NOT EXISTS

	-- Patch Q328310 Installed

	(SELECT 'Patch Q328310 Installed' FROM Windows_RegistryKeys WHERE
		RegistryKey = 'HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Hotfix\Q328310' AND
		EntryName = 'Installed' AND
		EntryValue = '1')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

--
-- ### END VULNERABLE CONFIGURATION
;

