--
-- OVAL-id: OVAL657
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0211' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- xinetd version is less than 2:2.3.11-1.9.0

	(SELECT 'xinetd version is less than 2:2.3.11-1.9.0' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'xinetd' AND
		RPMTestedEpoch = '2' AND
		RPMTestedVersion = '2.3.11' AND
		RPMTestedRelease = '1.9.0' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- xinetd is listening to the network

	(SELECT 'xinetd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%xinetd%')

--
-- ### END VULNERABLE CONFIGURATION
;

