--
-- OVAL-id: OVAL634
--
-- SchemaVersion: 3.00
--

SELECT 'CAN-2003-0135' FROM Placeholder WHERE

-- ### BEGIN VULNERABLE SOFTWARE EXISTS
--

EXISTS

	-- Red Hat 9 is installed

	(SELECT 'Red Hat 9 is installed' FROM RedHat_RPMinfo WHERE
		RPMName = 'redhat-release' AND
		RPMVersion = '9')

AND EXISTS

	-- ix86 architecture

	(SELECT 'ix86 architecture' FROM RedHat_Uname WHERE
		MachineClass LIKE 'i%86%')

AND EXISTS

	-- vsftpd version is less than 1.1.3-8

	(SELECT 'vsftpd version is less than 1.1.3-8' FROM RedHat_RPMVersionCompare WHERE
		RPMName = 'vsftpd' AND
		RPMTestedEpoch = 'NULL' AND
		RPMTestedVersion = '1.1.3' AND
		RPMTestedRelease = '8' AND
		RPMInstalledVersion = 'earlier')

--
-- ### END VULNERABLE SOFTWARE EXISTS

-- ### BEGIN VULNERABLE CONFIGURATION EXISTS
--

AND EXISTS

	-- vsftpd is listening to the network

	(SELECT 'vsftpd is listening to the network' FROM RedHat_InetListeningServers WHERE
		ProgramName LIKE '%vsftpd%' AND
		Protocol = 'TCP')

--
-- ### END VULNERABLE CONFIGURATION
;

